/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;
import vazkii.botania.mixin.AccessorDamageSource;

public class ItemTerrasteelHelm
extends ItemTerrasteelArmor
implements IManaDiscountArmor,
IAncientWillContainer {
    public static final String TAG_ANCIENT_WILL = "AncientWill";

    public ItemTerrasteelHelm(Item.Properties props) {
        super(EquipmentSlot.HEAD, props);
    }

    @Override
    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        if (!world.f_46443_ && this.hasArmorSet(player)) {
            int food = player.m_36324_().m_38702_();
            if (food > 0 && food < 18 && player.m_36325_() && player.f_19797_ % 80 == 0) {
                player.m_5634_(1.0f);
            }
            if (player.f_19797_ % 10 == 0) {
                ManaItemHandler.instance().dispatchManaExact(stack, player, 10, true);
            }
        }
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, Player player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        ItemNBTHelper.setBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), true);
    }

    @Override
    public boolean hasAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemTerrasteelHelm.hasAncientWill_(stack, will);
    }

    private static boolean hasAncientWill_(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemNBTHelper.getBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), false);
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, type)) continue;
            list.add((Component)new TranslatableComponent("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static boolean hasAnyWill(ItemStack stack) {
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!ItemTerrasteelHelm.hasAncientWill_(stack, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTerraArmorSet(Player player) {
        return ((ItemTerrasteelHelm)ModItems.terrasteelHelm).hasArmorSet(player);
    }

    public static float getCritDamageMult(Player player) {
        ItemStack stack;
        if (ItemTerrasteelHelm.hasTerraArmorSet(player) && !(stack = player.m_6844_(EquipmentSlot.HEAD)).m_41619_() && stack.m_41720_() instanceof ItemTerrasteelHelm && ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.DHAROK)) {
            return 1.0f + (1.0f - player.m_21223_() / player.m_21233_()) * 0.5f;
        }
        return 1.0f;
    }

    public static void onEntityAttacked(DamageSource source, float amount, Player player, LivingEntity entity) {
        ItemStack stack;
        if (ItemTerrasteelHelm.hasTerraArmorSet(player) && !(stack = player.m_6844_(EquipmentSlot.HEAD)).m_41619_() && stack.m_41720_() instanceof ItemTerrasteelHelm) {
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.AHRIM)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1));
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.GUTHAN)) {
                player.m_5634_(amount * 0.25f);
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.TORAG)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.VERAC)) {
                ((AccessorDamageSource)source).botania_setBypassArmor();
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.KARIL)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
            }
        }
    }
}

